/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.mobility.AgentMobilitySlice;
import jade.security.Credentials;
import jade.security.JADESecurityException;
import jade.util.leap.List;

public class AgentMobilityProxy
extends SliceProxy
implements AgentMobilitySlice {
    public void createAgent(AID agentID, byte[] serializedInstance, String classSiteName, boolean isCloned, boolean startIt) throws IMTPException, ServiceException, NotFoundException, NameClashException, JADESecurityException {
        try {
            GenericCommand cmd = new GenericCommand("1", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(serializedInstance);
            cmd.addParam(classSiteName);
            cmd.addParam(new Boolean(isCloned));
            cmd.addParam(new Boolean(startIt));
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof NameClashException) {
                    throw (NameClashException)result;
                }
                if (result instanceof JADESecurityException) {
                    throw (JADESecurityException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public byte[] fetchClassFile(String className, String agentName) throws IMTPException, ClassNotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("2", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(className);
            cmd.addParam(agentName);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (byte[])result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void moveAgent(AID agentID, Location where) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("3", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void copyAgent(AID agentID, Location where, String newName) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("4", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            cmd.addParam(newName);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public boolean prepare() throws IMTPException {
        try {
            GenericCommand cmd = new GenericCommand("5", "jade.core.mobility.AgentMobility", null);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (Boolean)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public boolean transferIdentity(AID agentID, Location src, Location dest) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("6", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(src);
            cmd.addParam(dest);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (Boolean)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void handleTransferResult(AID agentID, boolean result, List messages) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("7", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(new Boolean(result));
            cmd.addParam(messages);
            Node n = this.getNode();
            Object res = n.accept(cmd);
            if (res != null && res instanceof Throwable) {
                if (res instanceof IMTPException) {
                    throw (IMTPException)res;
                }
                if (res instanceof NotFoundException) {
                    throw (NotFoundException)res;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)res);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    public void clonedAgent(AID agentID, ContainerID cid, Credentials creds) throws IMTPException, JADESecurityException, NotFoundException, NameClashException {
        try {
            GenericCommand cmd = new GenericCommand("8", "jade.core.mobility.AgentMobility", null);
            cmd.addParam(agentID);
            cmd.addParam(cid);
            cmd.addParam(creds);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof JADESecurityException) {
                    throw (JADESecurityException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof NameClashException) {
                    throw (NameClashException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }
}

